import os
import re
import mmap


def get_results_from_file(file_path: str, keys: list, dtypes: list):
    results = {k: [] for k in keys}
    with open(file_path, 'r') as file:
        pattern = re.compile(r'-?\d+\.*\d*e?-?\d*')
        for line in file.readlines():
            for k, dtp in zip(keys, dtypes):
                pos = line.find(k)
                if pos != -1:
                    score = float(pattern.search(line[pos:]).group())
                    results[k].append(score)

    return results

